/*
 * Decompiled with CFR 0.152.
 */
package generativedesign;

import generativedesign.GenerativeDesign;
import processing.core.PApplet;

class ColorObject {
    private static final long serialVersionUID = 1L;
    float x = 0.0f;
    float y = 0.0f;
    float z = 0.0f;
    float a = 0.0f;
    float grayscale = 0.0f;
    int c;

    ColorObject(PApplet parent, int c) {
        if (parent.g.colorMode == 3) {
            this.x = parent.hue(c);
            this.y = parent.saturation(c);
            this.z = parent.brightness(c);
        } else {
            this.x = parent.red(c);
            this.y = parent.green(c);
            this.z = parent.blue(c);
        }
        this.a = parent.alpha(c);
        this.c = c;
    }

    ColorObject(PApplet parent, int c, float fx, float fy, float fz) {
        if (parent.g.colorMode == 3) {
            float[] rgb = new float[3];
            rgb = GenerativeDesign.HSBtoRGB(parent.hue(c), parent.saturation(c), parent.brightness(c));
            this.grayscale = rgb[0] * fx + rgb[1] * fy + rgb[2] * fz;
        } else {
            this.grayscale = parent.red(c) * fx + parent.green(c) * fy + parent.blue(c) * fz;
        }
        this.a = parent.alpha(c);
        this.c = c;
    }
}

