/*
 * Decompiled with CFR 0.152.
 */
package generativedesign;

import processing.core.PApplet;
import processing.core.PVector;

public class Node
extends PVector {
    public String id = "";
    public float diameter = 0.0f;
    public float minX = -3.4028235E38f;
    public float maxX = Float.MAX_VALUE;
    public float minY = -3.4028235E38f;
    public float maxY = Float.MAX_VALUE;
    public float minZ = -3.4028235E38f;
    public float maxZ = Float.MAX_VALUE;
    public PVector velocity = new PVector();
    PVector pVelocity = new PVector();
    public float maxVelocity = 10.0f;
    public float damping = 0.5f;
    public float radius = 200.0f;
    public float strength = -1.0f;
    public float ramp = 1.0f;

    public Node() {
    }

    public Node(float theX, float theY) {
        this.x = theX;
        this.y = theY;
    }

    public Node(float theX, float theY, float theZ) {
        this.x = theX;
        this.y = theY;
        this.z = theZ;
    }

    public Node(PVector theVector) {
        this.x = theVector.x;
        this.y = theVector.y;
        this.z = theVector.z;
    }

    public void rotateX(float theAngle) {
        float newy = this.y * PApplet.cos((float)theAngle) - this.z * PApplet.sin((float)theAngle);
        float newz = this.y * PApplet.sin((float)theAngle) + this.z * PApplet.cos((float)theAngle);
        this.y = newy;
        this.z = newz;
    }

    public void rotateY(float theAngle) {
        float newx = this.x * PApplet.cos((float)(-theAngle)) - this.z * PApplet.sin((float)(-theAngle));
        float newz = this.x * PApplet.sin((float)(-theAngle)) + this.z * PApplet.cos((float)(-theAngle));
        this.x = newx;
        this.z = newz;
    }

    public void rotateZ(float theAngle) {
        float newx = this.x * PApplet.cos((float)theAngle) - this.y * PApplet.sin((float)theAngle);
        float newy = this.x * PApplet.sin((float)theAngle) + this.y * PApplet.cos((float)theAngle);
        this.x = newx;
        this.y = newy;
    }

    public void attract(Node[] theNodes) {
        int i = 0;
        while (i < theNodes.length) {
            Node otherNode = theNodes[i];
            if (otherNode == null) break;
            if (otherNode != this) {
                this.attract(otherNode);
            }
            ++i;
        }
    }

    public void attract(Node theNode) {
        float d = PVector.dist((PVector)this, (PVector)theNode);
        if (d > 0.0f && d < this.radius) {
            float s = PApplet.pow((float)(d / this.radius), (float)(1.0f / this.ramp));
            float f = s * 9.0f * this.strength * (1.0f / (s + 1.0f) + (s - 3.0f) / 4.0f) / d;
            PVector df = PVector.sub((PVector)this, (PVector)theNode);
            df.mult(f);
            theNode.velocity.x += df.x;
            theNode.velocity.y += df.y;
            theNode.velocity.z += df.z;
        }
    }

    public void update() {
        this.update(false, false, false);
    }

    public void update(boolean theLockX, boolean theLockY, boolean theLockZ) {
        this.velocity.limit(this.maxVelocity);
        this.pVelocity = this.velocity.get();
        if (!theLockX) {
            this.x += this.velocity.x;
        }
        if (!theLockY) {
            this.y += this.velocity.y;
        }
        if (!theLockZ) {
            this.z += this.velocity.z;
        }
        if (this.x < this.minX) {
            this.x = this.minX - (this.x - this.minX);
            this.velocity.x = -this.velocity.x;
        }
        if (this.x > this.maxX) {
            this.x = this.maxX - (this.x - this.maxX);
            this.velocity.x = -this.velocity.x;
        }
        if (this.y < this.minY) {
            this.y = this.minY - (this.y - this.minY);
            this.velocity.y = -this.velocity.y;
        }
        if (this.y > this.maxY) {
            this.y = this.maxY - (this.y - this.maxY);
            this.velocity.y = -this.velocity.y;
        }
        if (this.z < this.minZ) {
            this.z = this.minZ - (this.z - this.minZ);
            this.velocity.z = -this.velocity.z;
        }
        if (this.z > this.maxZ) {
            this.z = this.maxZ - (this.z - this.maxZ);
            this.velocity.z = -this.velocity.z;
        }
        this.velocity.mult(1.0f - this.damping);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String theID) {
        this.id = theID;
    }

    public float getDiameter() {
        return this.diameter;
    }

    public void setDiameter(float theDiameter) {
        this.diameter = theDiameter;
    }

    public void setBoundary(float theMinX, float theMinY, float theMinZ, float theMaxX, float theMaxY, float theMaxZ) {
        this.minX = theMinX;
        this.maxX = theMaxX;
        this.minY = theMinY;
        this.maxY = theMaxY;
        this.minZ = theMinZ;
        this.maxZ = theMaxZ;
    }

    public void setBoundary(float theMinX, float theMinY, float theMaxX, float theMaxY) {
        this.minX = theMinX;
        this.maxX = theMaxX;
        this.minY = theMinY;
        this.maxY = theMaxY;
    }

    public float getMinX() {
        return this.minX;
    }

    public void setMinX(float theMinX) {
        this.minX = theMinX;
    }

    public float getMaxX() {
        return this.maxX;
    }

    public void setMaxX(float theMaxX) {
        this.maxX = theMaxX;
    }

    public float getMinY() {
        return this.minY;
    }

    public void setMinY(float theMinY) {
        this.minY = theMinY;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public void setMaxY(float theMaxY) {
        this.maxY = theMaxY;
    }

    public float getMinZ() {
        return this.minZ;
    }

    public void setMinZ(float theMinZ) {
        this.minZ = theMinZ;
    }

    public float getMaxZ() {
        return this.maxZ;
    }

    public void setMaxZ(float theMaxZ) {
        this.maxZ = theMaxZ;
    }

    public PVector getVelocity() {
        return this.velocity;
    }

    public void setVelocity(PVector theVelocity) {
        this.velocity = theVelocity;
    }

    public float getMaxVelocity() {
        return this.maxVelocity;
    }

    public void setMaxVelocity(float theMaxVelocity) {
        this.maxVelocity = theMaxVelocity;
    }

    public float getDamping() {
        return this.damping;
    }

    public void setDamping(float theDamping) {
        this.damping = theDamping;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float theRadius) {
        this.radius = theRadius;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float theStrength) {
        this.strength = theStrength;
    }

    public float getRamp() {
        return this.ramp;
    }

    public void setRamp(float theRamp) {
        this.ramp = theRamp;
    }
}

