class AppResults {
  boolean firstCall = true;

  float avgValue = 0.0f;
  float avgDeviation = 0.0f;
  float avgLinDeviation = 0.0f;

  float[] deviationData = null;
  float deviationDataMin = Float.MAX_VALUE;
  float deviationDataMax = Float.MIN_VALUE;

  float[] linDeviationData = null;
  float linDeviationDataMin = Float.MAX_VALUE;
  float linDeviationDataMax = Float.MIN_VALUE;

  PFont fontHeaderText;
  PFont fontVisValues;

  TextButton prevButton;

  AppResults() {
    fontHeaderText = loadFont("SansSerif-20.vlw");
    fontVisValues = loadFont("SansSerif-9.vlw");

    prevButton = new TextButton(370, 550, 60, 20, "OK", color(180), color(220), true);
  }

  void display() {
    //    fill(200);
    //    textAlign(LEFT);
    //    textFont(fontHeaderText, 20);
    //    text("Average log. deviation x: " + avgDeviation, 20, 80);

    textFont(fontHeaderText, 20);
    textAlign(LEFT);
    fill(200);
    text("Logarithmische Abweichung x = log A' / log A", 50, 100);

    displayVisualizationData(deviationData, 50, 300, 600, 300, max(abs(deviationDataMax), abs(deviationDataMin)), 1.0f);
    displayMinAvgMax(680, 305, deviationDataMin, avgValue, avgDeviation, deviationDataMax);

    prevButton.display();

    /*    textFont(fontHeaderText, 20);
     textAlign(LEFT);
     fill(200);
     text("Lineare Abweichung:", 50, 375);
     
     displayVisualizationData(linDeviationData, 50, 450, 600, 100, 2.0f * max(abs(linDeviationDataMax), abs(linDeviationDataMin)), 1.0f);
     displayMinAvgMax(680, 455, linDeviationDataMin, avgLinDeviation, linDeviationDataMax);*/
  }

  void displayVisualizationData(float[] data, int xOffset, int yOffset, int visWidth, int visHeight, float dataMaximum, float dataShift) {
    if (data == null) return;

    stroke(100);

    // init values
    int barBorder = 5;
    int barWidth = visWidth / data.length - 2 * barBorder;
    float barHeightScale = 0.9f * visHeight / dataMaximum;
    float scaleSteps = (int)(8.0f / ceil(dataMaximum) * 100.0f) / 100.0f;
    if (scaleSteps < 0.25f) scaleSteps = 0.1f;
    else if (scaleSteps < 0.5f) scaleSteps = 0.25f;
    else if (scaleSteps < 1.0f) scaleSteps = 0.5f;
    else if (scaleSteps > 4.0f) scaleSteps = 4.0f;
    println("dataMaximum: " + dataMaximum);
    println("scaleSteps: " + scaleSteps);

    // make rect around whole diagram
    color(255);
    fill(50);
    rectMode(CORNER);
    stroke(180);
    rect(xOffset, yOffset - visHeight * 0.5, visWidth, visHeight);

    // display standard deviation area
    int yAvg = yOffset - (int)((avgValue - 1) * barHeightScale);
    noStroke();
    int yStd = (int)(avgDeviation * barHeightScale);
    rectMode(CORNER);
    fill(80);
    rect(xOffset + 1, yOffset - yStd, visWidth - 1, yStd * 2);

    // display avg line
    stroke(200, 200, 0);
    line(xOffset, yAvg, xOffset + visWidth, yAvg);

    // make diagram lines and values
    stroke(180);
    int lineMax = (int)((float)ceil(dataMaximum / 2) * scaleSteps);
    //    if (lineMax % 2 == 0) lineMax++;
    //    if (lineMax > 5) lineMax = 5; 
    //    int maxVal = (lineMax - 1) / 2;
    println("lineMax: " + lineMax);
    //    println("maxVal: " + maxVal);
    for (float i = -lineMax; i <= lineMax; i++) {
      float v = (float)(i/scaleSteps);
      int y = yOffset + (int)(v * barHeightScale);
      if (y <= yOffset - visHeight * 0.5 || y>= yOffset + visHeight * 0.5) continue;
      line(xOffset, y, xOffset + visWidth, y);

      fill(200);
      textFont(fontVisValues, 9);
      textAlign(RIGHT);
      text(formatValue2(-v + dataShift), xOffset - 5, y + 5);
    }

    fill(200);
    textFont(fontVisValues, 9);
    textAlign(LEFT);
    text("Versuch", xOffset + visWidth + 10, yOffset - visHeight/2 - 5);

    fill(200);
    textFont(fontVisValues, 9);
    textAlign(LEFT);
    text("Versuchserg. x", xOffset + visWidth + 10, yOffset + visHeight/2 + 17);

    // display data
    int xBarOffset = 0;
    float localMax = max((deviationDataMax - dataShift), (dataShift - deviationDataMin));    
    for (int i = 0; i < data.length; i++) {
      float v = data[i];

      // display bar
      float c;

      if (v >= 0.0f) 
        c = v / localMax;
      else
        c = -v / localMax;

      fill(200 * c, 200 * (1-c), 0);  

      rectMode(CORNER);
      rect(xOffset + xBarOffset + barBorder, yOffset, barWidth, -v * barHeightScale);

      // display test number and value
      fill(200);
      textFont(fontVisValues, 9);
      textAlign(CENTER);
      text((i+1), xOffset + xBarOffset + barBorder + barWidth / 2, yOffset - visHeight/2 - 5);
      text(formatValue2(v + dataShift), xOffset + xBarOffset + barBorder + barWidth / 2, yOffset + visHeight/2 + 17);

      xBarOffset += barWidth + 2 * barBorder;
    }
  }

  void displayMinAvgMax(int xPos, int yPos, float min, float avg, float dev, float max) {
    fill(200);    
    textFont(fontHeaderText, 20);
    textAlign(LEFT);
    fill(200, 0, 0);
    text("Max.: " + roundByValue(max, 100.0f), xPos, yPos - 30);
    fill(200, 200, 0);
    text("Mittel: " + roundByValue(avg, 100.0f), xPos, yPos);
    fill(80);
    text("Sigma: " + roundByValue(dev, 100.0f), xPos, yPos + 30);
    fill(200, 0, 0);
    text("Min.: " + roundByValue(min, 100.0f), xPos, yPos + 60);
  }

  void update() {
    if (firstCall) {
      buildVisualizationData();
      firstCall = false;
    }

    prevButton.update();

    if (prevButton.pressed()) {
      appState = APP_STATE_START;
    }
  }

  void buildVisualizationData() {
    float deviationSum = 0.0f;
    float avgSum = 0.0f;
    float linDeviationSum = 0.0f;
    deviationData = new float[results.size()];
    linDeviationData = new float[results.size()];

    for (int i = 0; i < results.size(); i++) {
      Result res = (Result)results.get(i);
      deviationData[i] = res.userDeviation - 1;
      linDeviationData[i] = res.userLinDeviation;
      deviationSum += (res.userDeviation - 1) * (res.userDeviation - 1);
      avgSum += res.userDeviation;
      linDeviationSum += res.userLinDeviation;

      if (res.userDeviation > deviationDataMax) {
        deviationDataMax = res.userDeviation;
      }

      if (res.userDeviation < deviationDataMin) {
        deviationDataMin = res.userDeviation;
      }      


      if (res.userLinDeviation > linDeviationDataMax) {
        linDeviationDataMax = res.userLinDeviation;
      }

      if (res.userLinDeviation < linDeviationDataMin) {
        linDeviationDataMin = res.userLinDeviation;
      }
    }

    avgValue = avgSum / results.size();
    avgDeviation = sqrt(deviationSum / results.size());
    avgLinDeviation = linDeviationSum / results.size();
  }

  float roundByValue(float v, float r) {
    return round(v * r) / r;
  }

  String formatValue1(float v) {
    DecimalFormat df =   new DecimalFormat("0.0");

    return df.format(v);
  }

  String formatValue2(float v) {
    DecimalFormat df =   new DecimalFormat("0.0#");

    return df.format(v);
  }
}

