class AppTest {
  int testNum;
  int testMax;
  int testType;   // first five tests: (testType = 0) create new shapes, last five tests: (testType = 1) select right ratio

  PFont fontHeaderText;

  float[] shapeTestSizes = {
    0.25f, 0.33f, 0.5f, 0.75f, 1.5f, 2.0f, 2.5f, 3.0f, 4.0f, 5.0f
  };

  //  float[] shapeTestSizesShuffled;

  int baseShapeSize;          // base width of the original shape
  float baseShapeArea;        // base area of the original shape  
  float origShapeAreaRatio;   // the ratio by which baseShapeArea is increased
  float origShapeArea;        // is baseShapeArea * origShapeSizeRatio
  int origShapeSize;          // the width of the original shape with the area of origShapeArea
  float expectedAreaRatio;    // the area ratio the user shall achieve
  float userShapeArea;        // is calculated from the user's input (testType = 0) or baseShapeArea * expectedAreaRatio (testType = 1)
  int userShapeSize;          // the width of the user's shape

  int selectedRatioIndex = -1;

  int expAreaSize = 300;
  int leftAreaCenterX = SCREEN_W / 2 - (expAreaSize / 2 + 10);
  int rightAreaCenterX = SCREEN_W / 2 + (expAreaSize / 2 + 10);
  int areaCenterY = SCREEN_H / 2 - 20;

  RectButton areaLeft;
  RectButton areaRight;

  //TriangleButton prevButton;
  TriangleButton nextButton;

  ArrayList answerSelection;  // List of TextButtons

  AppTest() {
    testNum = 0;
    testMax = 20;

    fontHeaderText = loadFont("SansSerif-20.vlw");

    //    shapeTestSizesShuffled = shuffle(shapeTestSizes);

    baseShapeSize = 50;
    baseShapeArea = calcArea(baseShapeSize);
    userShapeSize = 0;

    areaLeft = new RectButton(leftAreaCenterX, areaCenterY, expAreaSize, color(40), color(40), false);
    areaRight = new RectButton(rightAreaCenterX, areaCenterY, expAreaSize, color(40), color(40), false);

    //prevButton = new TriangleButton(110, 550, 20, 30, 90, color(180), color(220), true);
    nextButton = new TriangleButton(690, 550, 20, 30, 270, color(180), color(220), true);

    answerSelection = new ArrayList();
    for (int i = 0; i < shapeTestSizes.length; i++) {
      String label = generateStringFromRatio(shapeTestSizes[i]);
      int col = i % (shapeTestSizes.length / 2);
      int row = (i / (shapeTestSizes.length / 2));
      TextButton btn = new TextButton(150 + col * 125, 500 + row * 35, 120, 30, label, color(180), color(220), true);
      answerSelection.add(btn);
    }

    initValues();
  }

  //--------------------------------------------//
  // main display functions //
  //--------------------------------------------//

  void display() {
    fill(200);
    textAlign(LEFT);
    textFont(fontHeaderText, 20);
    text("Test #" + (testNum + 1) + "/" + testMax + ":", 20, 80);

    displayShapeTest();
    displayFooter();
  }

  void displayFooter() {
    if (testNum > 0) {
      //prevButton.display();
    }

    if (testType == 0 && userShapeSize > 0) {
      nextButton.display();
    }
  }

  //--------------------------------------------//
  // update functions //
  //--------------------------------------------//

  void update() {
    if (testNum >= testMax) {
      appState = APP_STATE_RESULTS;
      testNum = 0;
      initValues();
      return;
    }

    updateShapeTest();
    updateFooter();
  }

  void updateFooter() {
    //    if (testNum > 0) {
    //      prevButton.update();
    //
    //      if (prevButton.pressed()) {
    //        saveResults();
    //        testNum--;
    //      }
    //    }

    if (testType == 0 && userShapeSize > 0) {
      nextButton.update();

      if (nextButton.pressed()) {
        saveResults();
        testNum++;
      }
    }
  }

  //--------------------------------------------//
  // result handling //
  //--------------------------------------------//

  void saveResults() {
    // update Result object
    Result res = (Result)results.get(testNum);
    res.expectedRatio = expectedAreaRatio;
    res.testType = testType;
    res.origShapeArea = origShapeArea;

    if (testType == 0) {
      res.userShapeArea = calcArea(userShapeSize);
      res.userRatio = res.userShapeArea / res.origShapeArea;
    } 
    else {
      res.userShapeArea = res.origShapeArea * shapeTestSizes[selectedRatioIndex];
      res.userRatio = shapeTestSizes[selectedRatioIndex];
    }

    res.userDeviation = logAB(res.origShapeArea * res.expectedRatio, res.userShapeArea);
    
    float expectedArea = res.origShapeArea * res.expectedRatio;
    if (expectedArea <= res.userShapeArea) {
      res.userLinDeviation = res.userShapeArea / expectedArea;
    }
    else {
      res.userLinDeviation = -expectedArea / res.userShapeArea;
    }

    // reset results
    initValues();

    //println("Saved result:" + res);
  }

  //--------------------------------------------//
  // shape test functions //
  //--------------------------------------------//

  void initValues() {
    selectedRatioIndex = -1;
    userShapeSize = 0;

    // set the test tyoe
    testType = (testNum+1) / shapeTestSizes.length;  // 0 is creating a shape, 1 is selecting the shape's area ratio

    // calculate values for the "left side", i. e. for the reference shape
    int testIndex = (int)random(shapeTestSizes.length);
    origShapeAreaRatio = shapeTestSizes[testIndex];
    origShapeArea = baseShapeArea * origShapeAreaRatio;
    origShapeSize = (int)calcWidthFromArea(origShapeArea);

    // calculate values for the "right side", i. e. for the user's shape
    int minIndex = 0;
    int maxIndex = shapeTestSizes.length;
    
    // ensure it doesnt get too big or too small
    if (testIndex < 3)
      minIndex = 3;
    else if (testIndex > 6)
      maxIndex = 6;  
    
    expectedAreaRatio = shapeTestSizes[(int)random(minIndex, maxIndex)];

    if (testType == 1) {
      userShapeArea = origShapeArea * expectedAreaRatio;
      userShapeSize = (int)calcWidthFromArea(userShapeArea);
    }
  }

  void displayShapeTest() {
    // help text
    fill(200);
    textFont(fontHeaderText, 20);
    textAlign(CENTER);

    if (testType == 0) {
      text("Mache die Form auf der rechten Seite " + generateStringFromRatio(expectedAreaRatio) + " wie die auf der linken.", 400, 110);
    } 
    else {
      text("Wähle die richtige Antwort für die rechte Seite aus.", 400, 110);
      text("Die Form auf der rechten Seite ist...", 400, 460);
    }

    // show "experiment area"
    areaLeft.display();
    areaRight.display();

    if (testType == 1) {
      for (int i = 0; i < answerSelection.size(); i++) {
        TextButton btn = (TextButton)answerSelection.get(i);
        btn.display();
      }
    }

    // show original shape on the left
    fill(180, 0, 0);
    if (shapeType == SHAPE_TYPE_CIRCLE) {
      ellipse(leftAreaCenterX, areaCenterY, origShapeSize, origShapeSize);
    } 
    else {
      rect(leftAreaCenterX, areaCenterY, origShapeSize, origShapeSize);
    }

    // show user's shape on the right
    fill(180, 0, 0);
    if (shapeType == SHAPE_TYPE_CIRCLE) {
      ellipse(rightAreaCenterX, areaCenterY, userShapeSize, userShapeSize);
    } 
    else {
      rect(rightAreaCenterX, areaCenterY, userShapeSize, userShapeSize);
    }
  }

  void updateShapeTest() {
    // manage user interaction
    if (testType == 0) {
      areaRight.update();

      if (areaRight.pressed()) {
        userShapeSize = (int)dist(mouseX, mouseY, rightAreaCenterX, areaCenterY) * 2;
        if (userShapeSize > expAreaSize - 5) {
          userShapeSize = expAreaSize - 5;
        }
      }
    } 
    else {
      for (int i = 0; i < answerSelection.size(); i++) {
        TextButton btn = (TextButton)answerSelection.get(i);
        btn.update();

        if (btn.pressed()) {
          selectedRatioIndex = i;
          saveResults();
          testNum++;

          return;
        }
      }
    }
  }

  //--------------------------------------------//
  // helper //
  //--------------------------------------------//

  float calcArea(float width) {
    if (shapeType == SHAPE_TYPE_RECT) {
      return width * width;
    } 
    else {
      return PI / 4.0f * width * width;
    }
  }

  float calcWidthFromArea(float area) {
    if (shapeType == SHAPE_TYPE_RECT) {
      return sqrt(area);
    } 
    else {
      return sqrt(area / PI) * 2.0f;
    }
  }

  String generateStringFromRatio(float ratio) {
    String s;
    s = ratio + " mal größer";

    if (ratio == 0.25f) {
      s = "4 mal kleiner";
    } 

    if (ratio == 0.33f) {
      s = "3 mal kleiner";
    } 

    if (ratio == 0.5f) {
      s = "halb so groß";
    } 

    if (ratio == 0.75f) {
      s = "3/4 so groß";
    }

    return s;
  }
  
  float logAB (float a, float b) {
    return log(b) / log(a);
  }

  //  // Code by "fjen", taken from http://processing.org/discourse/yabb2/YaBB.pl?num=1194572947
  //  float[] shuffle(float[] toShuffle) {
  //    float[] shuffled = new float[toShuffle.length];
  //
  //    int i=0;
  //
  //    while ( toShuffle.length > 0 )
  //    {
  //      int rnd = int(random(toShuffle.length));  // by default random() never returns the given max value
  //      shuffled[i] = toShuffle[rnd];
  //      i++;
  //      if ( rnd > 0 && rnd < toShuffle.length-1 )
  //        toShuffle = concat(subset(toShuffle,0,rnd), subset(toShuffle,rnd+1,toShuffle.length-rnd-1));
  //      else if ( rnd == 0 )
  //        toShuffle = subset(toShuffle,1,toShuffle.length-1);
  //      else
  //        toShuffle = shorten( toShuffle );
  //    }
  //
  //    return shuffled;
  //  }
}

