class Button
{
  int x, y;
  int sizeW;
  int sizeH;
  color basecolor, highlightcolor;
  color currentcolor;
  boolean over = false;
  boolean pressed = false;
  int lastClick = 0;
  int clickLockTime = 0;  

  void update() 
  {
    if(over()) {
      currentcolor = highlightcolor;
    } 
    else {
      currentcolor = basecolor;
    }
  }

  boolean pressed() 
  {
    if (clickLockTime > 0) {
      boolean pressed = (millis() - lastClick > clickLockTime && mousePressed && over);
      if (pressed)
        lastClick = millis();
      
      return pressed;
    }
    
    return (mousePressed && over);   
  }

  boolean over() 
  { 
    return true; 
  }

  boolean overRect(int x, int y, int width, int height) 
  {
    if (mouseX >= x && mouseX <= x+width && 
      mouseY >= y && mouseY <= y+height) {
      return true;
    } 
    else {
      return false;
    }
  }

  boolean overCircle(int x, int y, int diameter) 
  {
    float disX = x - mouseX;
    float disY = y - mouseY;
    if(sqrt(sq(disX) + sq(disY)) < diameter/2 ) {
      return true;
    } 
    else {
      return false;
    }
  }

}

class CircleButton extends Button
{ 
  CircleButton(int ix, int iy, int isize, color icolor, color ihighlight, boolean clickLock) 
  {
    x = ix;
    y = iy;
    sizeW = isize;
    sizeH = isize;
    basecolor = icolor;
    highlightcolor = ihighlight;
    currentcolor = basecolor;
    
    if (clickLock)
      clickLockTime = 500;
    else 
      clickLockTime = 0;
  }

  boolean over() 
  {
    if( overCircle(x, y, sizeW) ) {
      over = true;
      return true;
    } 
    else {
      over = false;
      return false;
    }
  }

  void display() 
  {
    stroke(255);
    fill(currentcolor);
    ellipse(x, y, sizeW, sizeW);
  }
}

class RectButton extends Button
{
  RectButton(int ix, int iy, int isize, color icolor, color ihighlight, boolean clickLock) 
  {
    x = ix;
    y = iy;
    sizeW = isize;
    sizeH = isize;
    basecolor = icolor;
    highlightcolor = ihighlight;
    currentcolor = basecolor;
    
    if (clickLock)
      clickLockTime = 500;
    else 
      clickLockTime = 0;
  }

  boolean over() 
  {
    if( overRect(x-sizeW/2, y-sizeW/2, sizeW, sizeW) ) {
      over = true;
      return true;
    } 
    else {
      over = false;
      return false;
    }
  }

  void display() 
  {
    stroke(255);
    fill(currentcolor);
    rectMode(CENTER);
    rect(x, y, sizeW, sizeW);
  }
}

class TriangleButton extends Button
{
  float angle;
  
  TriangleButton(int ix, int iy, int isizeW, int isizeH, float iangle, color icolor, color ihighlight, boolean clickLock) 
  {
    x = ix;
    y = iy;
    sizeW = isizeW;
    sizeH = isizeH;
    angle = radians(iangle);
    basecolor = icolor;
    highlightcolor = ihighlight;
    currentcolor = basecolor;
    
    if (clickLock)
      clickLockTime = 500;
    else 
      clickLockTime = 0;
  }

  boolean over() 
  {
    if( overRect(x-sizeW/2, y-sizeH/2, sizeW, sizeH) ) {
      over = true;
      return true;
    } 
    else {
      over = false;
      return false;
    }
  }

  void display() 
  {
    //shapeMode(CENTER);
    pushMatrix();
    stroke(255);
    fill(currentcolor);
    translate(x, y);
    rotate(angle);
    triangle(-sizeW/2, -sizeH/2, sizeW/2.5f, -sizeH/2, 0, sizeH/2);
    popMatrix();
  }
}

class TextButton extends Button
{
  PFont labelFont;
  String label;
  
  TextButton(int ix, int iy, int isizeW, int isizeH, String ilabel, color icolor, color ihighlight, boolean clickLock) 
  {
    x = ix;
    y = iy;
    sizeW = isizeW;
    sizeH = isizeH;
    label = ilabel;
    basecolor = icolor;
    highlightcolor = ihighlight;
    currentcolor = basecolor;
    
    labelFont = loadFont("SansSerif-14.vlw");
    
    if (clickLock)
      clickLockTime = 500;
    else 
      clickLockTime = 0;
  }

  boolean over() 
  {
    if( overRect(x-sizeW/2, y-sizeH/2, sizeW, sizeH) ) {
      over = true;
      return true;
    } 
    else {
      over = false;
      return false;
    }
  }

  void display() 
  {
    stroke(255);
    fill(currentcolor);
    rectMode(CENTER);
    rect(x, y, sizeW, sizeH);
    fill(255);
    textFont(labelFont, 14);
    textAlign(CENTER);
    text(label, x, y + 5);
  }
}
