// 1. Auswahl Kreis / Quadrat
// 2. Benutzer den Kreis / das Quatrat ziehen lassen!
// 3. Visualisieren des Erg.

final int APP_STATE_START = 1;
final int APP_STATE_TEST = 2;
final int APP_STATE_RESULTS = 3;
final int APP_STATE_RESULTS_ALL = 4;

final int SHAPE_TYPE_CIRCLE = 1;
final int SHAPE_TYPE_RECT = 2;

final int SCREEN_W = 800;
final int SCREEN_H = 600;

final boolean DEBUG_VIS = false;

int appState;
int shapeType;
PFont fontHeader;

AppStart appStart;
AppTest appTest;
AppResults appResults;

ArrayList results = new ArrayList();  //List with testNum -> Result mapping

void setup() {
  if (!DEBUG_VIS)
    appState = APP_STATE_START;
  else
    appState = APP_STATE_RESULTS;
    
  shapeType = SHAPE_TYPE_CIRCLE;
    
  smooth();
  size(SCREEN_W, SCREEN_H);
  stroke(255);
  background(0, 0, 0);
  
  fontHeader = loadFont("SansSerif-28.vlw");
  
  appStart = new AppStart();
  appTest = new AppTest();
  appResults = new AppResults();
  
  // fill the results with empty values
  for (int i = 0; i < appTest.testMax; i++) {
    Result res = new Result();
    res.testNum = i;
    
    if (DEBUG_VIS) {  // fill with random values for debugging
      res.userDeviation = random(0.7f, 1.4f);
      res.userLinDeviation = random(-2.0f, 2.0f);
    }
    
    results.add(res);
  }
} 

void draw() {
  background(0, 0, 0);
  showHeader();
  updateMain();
  showMain();
  showFooter();
}

void showHeader() {
  fill(255);
  String title = "";
  
  switch (appState) {
    case APP_STATE_START:
      title = "Wähle eine Form";
    break;
    case APP_STATE_TEST:
      title = "Testphase";
    break;
    case APP_STATE_RESULTS:
      title = "Individuelle Resultate";
    break;
    case APP_STATE_RESULTS_ALL:
      title = "Resulte vergangener Kandidaten";
    break;    
  }
  
  textFont(fontHeader, 28);
  textAlign(LEFT);
  text(title, 20, 50);
}

void updateMain() {
  switch (appState) {
    case APP_STATE_START:
      appStart.update();
    break;
    case APP_STATE_TEST:
      appTest.update();
    break;
    case APP_STATE_RESULTS:
    case APP_STATE_RESULTS_ALL:
      appResults.update();
    break;
    
  }
}

void showMain() {
  switch (appState) {
    case APP_STATE_START:
      appStart.display();
    break;
    case APP_STATE_TEST:
      appTest.display();
    break;
    case APP_STATE_RESULTS:
    case APP_STATE_RESULTS_ALL:
      appResults.display();
    break;
    
  }
}

void showFooter() {
  
}
