class AppResults {
  boolean firstCall = true;

  int testTypeCount = 10;
  int testsPerType = 5;

  ArrayList resultData; // ArrayList with ArrayList of data for each test type
  ArrayList resultDataMax; // ArrayList of Floats with maxium for each test type
  ArrayList resultDataMin; // ArrayList of Floats with minimum for each test type
  ArrayList resultDataAvg; // ArrayList of Floats with average for each test type

  float absResultDataMax = Float.MIN_VALUE;
  float avgReactionTime = 0.0f;

  PFont fontHeaderText;
  PFont fontVisValues;

  TextButton prevButton;

  AppResults() {
    fontHeaderText = loadFont("SansSerif-12.vlw");
    fontVisValues = loadFont("SansSerif-9.vlw");

    prevButton = new TextButton(370, 570, 60, 20, "OK", color(180), color(220), true);
  }

  void display() {    
    int w = 125;
    int h = 100;
    int bX = 25;
    int bY = 100;

    textFont(fontHeaderText, 12);
    textAlign(LEFT);
    fill(200);
    text("Bei allen Tests nach dem einfachen Reaktionstest wurde die durchschn. Reaktionsgeschw. von " + nf(avgReactionTime, 1, 2) + "Sek. abgezogen", 25, 100);
    text("Alle Angaben sind in Sekunden.", 25, 113);

    for (int i = 0; i < testTypeCount; i++) {
      int row = i / testsPerType;
      int col = i % testsPerType;

      int x = bX + col * (w + bX);
      int y = 140 + row * (h + bY);

      textFont(fontHeaderText, 12);
      textAlign(LEFT);
      fill(200);
      text((String)testTitles.get(i), x, y);

      displayVisualizationData(i, x, y + h/2 + 25, w, h);

      //      rectMode(CORNER);
      //      rect(bX + col * (w + bX), 100 + row * (h + bY), w, h);
    }

    //    displayVisualizationData(deviationData, 50, 300, 600, 300, max(abs(deviationDataMax), abs(deviationDataMin)), 1.0f);
    //    displayMinAvgMax(680, 305, deviationDataMin, avgValue, avgDeviation, deviationDataMax);

    prevButton.display();

    /*    textFont(fontHeaderText, 20);
     textAlign(LEFT);
     fill(200);
     text("Lineare Abweichung:", 50, 375);
     
     displayVisualizationData(linDeviationData, 50, 450, 600, 100, 2.0f * max(abs(linDeviationDataMax), abs(linDeviationDataMin)), 1.0f);
     displayMinAvgMax(680, 455, linDeviationDataMin, avgLinDeviation, linDeviationDataMax);*/
  }

  void displayVisualizationData(int dataId, int xOffset, int yOffset, int visWidth, int visHeight) {
    // get data
    if (resultData == null) return;
    
    ArrayList testData = (ArrayList)resultData.get(dataId);
    float testMax = ((Float)resultDataMax.get(dataId)).floatValue();
    float testMin = ((Float)resultDataMin.get(dataId)).floatValue();
    float testAvg = ((Float)resultDataAvg.get(dataId)).floatValue();

    stroke(100);

    // init values
    int barBorder = 2;
    int barWidth = visWidth / testData.size() - 2 * barBorder;
    float barHeightScale = 0.9f * visHeight / absResultDataMax;

    // make rect around whole diagram
    color(255);
    fill(50);
    rectMode(CORNER);
    stroke(180);
    rect(xOffset, yOffset - visHeight * 0.5, visWidth, visHeight);

    // display avg line
    int yAvg = yOffset + visHeight / 2 - (int)(testAvg * barHeightScale);
    stroke(200, 200, 0);
    line(xOffset, yAvg, xOffset + visWidth, yAvg);

    // display description
    //    fill(200);
    //    textFont(fontVisValues, 9);
    //    textAlign(LEFT);
    //    text("Versuch", xOffset + visWidth + 10, yOffset - visHeight/2 - 5);
    //
    //    fill(200);
    //    textFont(fontVisValues, 9);
    //    textAlign(LEFT);
    //    text("Erg.", xOffset + visWidth + 10, yOffset + visHeight/2 + 17);

    // display data
    int xBarOffset = 0;

    for (int i = 0; i < testData.size(); i++) {
      float v = ((Float)testData.get(i)).floatValue();

      // display bar
      float c = v / absResultDataMax;
      fill(200 * c, 200 * (1-c), 0);  

      rectMode(CORNER);
      rect(xOffset + xBarOffset + barBorder, yOffset + visHeight / 2, barWidth, -v * barHeightScale);

      // display test number and value
      fill(200);
      textFont(fontVisValues, 9);
      textAlign(CENTER);
      text((i+1), xOffset + xBarOffset + barBorder + barWidth / 2, yOffset - visHeight/2 - 5);
      text(nf(v, 1, 2), xOffset + xBarOffset + barBorder + barWidth / 2, yOffset + visHeight/2 + 17);

      xBarOffset += barWidth + 2 * barBorder;
    }
    
    displayMinAvgMax(xOffset, yOffset + visHeight / 2 + 30, testMin, testAvg, testMax);
  }

  void displayMinAvgMax(int xPos, int yPos, float min, float avg, float max) {
     fill(200);    
     textFont(fontVisValues, 9);
     textAlign(LEFT);
     text("min: " + nf(min, 1, 2), xPos, yPos);
     text("avg: " + nf(avg, 1, 2), xPos, yPos + 12);
     text("max: " + nf(max, 1, 2), xPos, yPos + 24);
  }

  void update() {
    if (firstCall) {
      buildVisualizationData();
      firstCall = false;
    }

    prevButton.update();

    if (prevButton.pressed()) {
      exit();
    }
  }

  void buildVisualizationData() {
    resultData = new ArrayList();
    resultDataMax = new ArrayList();
    resultDataMin = new ArrayList();
    resultDataAvg = new ArrayList();
    
    for (int i = 0; i < testTypeCount; i++) {  // for each test type
      ArrayList resultsForTest = new ArrayList();
      int testNumBegin = i * testsPerType;
      float resAvg = 0.0f;
      float resMax = Float.MIN_VALUE;
      float resMin = Float.MAX_VALUE;

      for (int testNum = testNumBegin; testNum < testNumBegin + testsPerType; testNum++) {
        float testRes = ((Result)results.get(testNum)).reactionTime;
        if (testNumBegin > 0) testRes -= avgReactionTime;
        resAvg += testRes / (float)testsPerType;
        if (testRes > resMax) resMax = testRes;
        if (testRes < resMin) resMin = testRes;
        resultsForTest.add(new Float(testRes));
      }
      
      if (testNumBegin == 0) {
        avgReactionTime = resAvg;
        println(avgReactionTime);
      }
      
      if (resMax > absResultDataMax) absResultDataMax = resMax;

      resultData.add(resultsForTest);
      resultDataMax.add(new Float(resMax));
      resultDataMin.add(new Float(resMin));
      resultDataAvg.add(new Float(resAvg));
    }
  }

  //  float roundByValue(float v, float r) {
  //    return round(v * r) / r;
  //  }
  //
  //  String formatValue1(float v) {
  //    DecimalFormat df =   new DecimalFormat("0.0");
  //
  //    return df.format(v);
  //  }
  //
  //  String formatValue2(float v) {
  //    DecimalFormat df =   new DecimalFormat("0.0#");
  //
  //    return df.format(v);
  //  }
}

