class AppTest {
  int testNum;
  int testMax;

  PFont fontHeaderText;

  int testTime;       // in millis
  int testStartTime;  // in millis

  float avgReactionTime;

  int testAreaSizeX = 600;
  int testAreaSizeY = 400;
  int fullAreaCenterX = SCREEN_W / 2;
  int areaCenterY = SCREEN_H / 2 + 50;

  boolean testIsRunning = false;

  RectButton testArea;

  Button objectToClick;
  color objColor;
  color distrColor;
  int prevObjX;
  int prevObjY;
  ArrayList distractorObjects;

  TextButton infoOkButton;

  //TriangleButton prevButton;
  TriangleButton nextButton;

  AppTest() {
    testNum = 0;
    testMax = 50;  // 10 testtypes with 5 tests

    fontHeaderText = loadFont("SansSerif-20.vlw");

    //    testArea = new RectButton(fullAreaCenterX, areaCenterY, testAreaSizeX, testAreaSizeY, color(40), color(40), false);

    infoOkButton = new TextButton(400, 530, 50, 30, "Ok", color(40), color(60), true);

    nextButton = new TriangleButton(690, 550, 30, 50, 270, color(180), color(220), true);

    distractorObjects = new ArrayList();

    if (!DEBUG_VIS) {
      initValues();
    }
  }

  //--------------------------------------------//
  // main display functions //
  //--------------------------------------------//

  void display() {
    fill(200);
    textAlign(LEFT);
    textFont(fontHeaderText, 20);
    text("Test #" + (testNum + 1) + "/" + testMax + ":", 20, 80);

    if (testIsRunning) {
      displayTest();
    } 
    else {
      displayInfo();
    }

    displayFooter();
  }

  void displayFooter() {
    //    if (testType == 0 && userShapeSize > 0) {
    //      nextButton.display();
    //    }
  }

  //--------------------------------------------//
  // update functions //
  //--------------------------------------------//

  void initValues() {
    // set the test type
    appState = (testNum+1) / 5 + 1;

    //    // reset other values
    //    testIsRunning = false;

    // init things for this test
    distractorObjects.clear();

    switch (appState) {
    case APP_STATE_TEST_0:
      {
        int randX = (int)random(0, testAreaSizeX - 100) + 100;
        int randY = (int)random(0, testAreaSizeY - 100) + 150;
        objectToClick = new RectButton(randX, randY, 50, 50, color(180, 0, 0), color(180, 0, 0), false);
        break;
      }
    case APP_STATE_TEST_1: 
    case APP_STATE_TEST_2:
    case APP_STATE_TEST_3:
    case APP_STATE_TEST_4:
    case APP_STATE_TEST_5:
    case APP_STATE_TEST_6:
    case APP_STATE_TEST_7:
    case APP_STATE_TEST_8:
    case APP_STATE_TEST_9:
      {
        int objSize = 50;
        int distrSize = 50;
        //        color distrColor = color(180);
        color thisDistrColor = distrColor;
        color thisObjColor = objColor;
        int numDistr = 10 + 5 * (testNum - 4);

        if (appState == APP_STATE_TEST_2) {
          objSize = 50;
          numDistr = 10 + 5 * (testNum - 9);
          thisDistrColor = distrColor = color(180);
          thisObjColor = distrColor;
        } 
        else if (appState == APP_STATE_TEST_3 || appState == APP_STATE_TEST_6) {
          numDistr = 15;

          if (appState == APP_STATE_TEST_3) {
            objSize = 50 + (20 - testNum) * 5;
            thisDistrColor = distrColor = color(180);
            thisObjColor = distrColor;
          } 
          else {
            if ((int)random(2) == 1) {
              thisObjColor = thisDistrColor;
            } else {
              thisObjColor = objColor;
            }
            
            objSize = 50 + (38 - testNum) * 5;
          }
        } 
        else if (appState == APP_STATE_TEST_4 || appState == APP_STATE_TEST_5) {
          objSize = 50;
          numDistr = 15;
        }

        if (appState == APP_STATE_TEST_1 || appState == APP_STATE_TEST_4 || appState == APP_STATE_TEST_5) {
          objectToClick = new RectButton(0, 0, objSize, objSize, thisObjColor, thisObjColor, false);
        } 
        else if (appState == APP_STATE_TEST_2 || appState == APP_STATE_TEST_3 || appState == APP_STATE_TEST_6) {
          objectToClick = new CircleButton(0, 0, objSize, thisObjColor, thisObjColor, false);
        }
        else if (appState == APP_STATE_TEST_7 || appState == APP_STATE_TEST_8 || appState == APP_STATE_TEST_9) {
          numDistr = 15;
        }

println("APPSTATE: " + appState);
println("thisDistrColor: " + thisDistrColor);

        int cols = 5;
        int rows = numDistr / cols + 1;
        int fieldW = testAreaSizeX / cols;
        int fieldH = testAreaSizeY / rows;

        int targetRow = (int)random(rows);
        int targetCol = (int)random(cols);

        Button distractor = null;
        for (int row = 0; row < rows; row++) {
          for (int col = 0; col < cols; col++) {
            int randX = col * fieldW + (int)random(0, fieldW - objSize / 2) + 100;
            int randY = row * fieldH + (int)random(0, fieldH - objSize / 2) + 150;

            if (targetRow == row && targetCol == col) {
              objectToClick.x = randX;
              objectToClick.y = randY;
            } 
            else {
              if (appState == APP_STATE_TEST_1) {
                distractor = new RectButton(randX, randY, distrSize, distrSize, thisDistrColor, color(0), false);
              } 
              
              if (appState == APP_STATE_TEST_3) {
                distractor = new CircleButton(randX, randY, distrSize, thisDistrColor, color(0), false);
              } 
              else {
                if (appState == APP_STATE_TEST_4) {
                  thisDistrColor = randColor(thisObjColor);
                } 
                else if (appState == APP_STATE_TEST_5 || appState == APP_STATE_TEST_6  || appState == APP_STATE_TEST_7  || appState == APP_STATE_TEST_8  || appState == APP_STATE_TEST_9) {
                  if ((int)random(2) == 1) {
                    thisDistrColor = objColor;
                  } 
                  else {
                    thisDistrColor = distrColor;
                  }
                }

                int distrShape = 0;
                float distrAngle = 0.0f;
                int randW = 0;
                int randH = 0;

                if (appState == APP_STATE_TEST_5 || appState == APP_STATE_TEST_6  || appState == APP_STATE_TEST_7  || appState == APP_STATE_TEST_8  || appState == APP_STATE_TEST_9) {
                  distrShape = (int)random(3);
                  distrAngle = random(360.0f);
                  randW = (int)random(-distrSize / 2, distrSize / 2);
                  randH = (int)random(-distrSize / 2, distrSize / 2);
                }

                switch (distrShape) {
                default:
                case 0:
                  distractor = new RectButton(randX, randY, distrSize + randW, distrSize + randH, thisDistrColor, color(0), false);
                  break;
                case 1:
                  distractor = new CircleButton(randX, randY, distrSize + randW, distrSize + randH, thisDistrColor, color(0), false);
                  break;
                case 2:
                  distractor = new TriangleButton(randX, randY, distrSize + randW, distrSize + randH, distrAngle, thisDistrColor, color(0), false);
                  break;
                }
              }

              println("Added distractor: " + distractor);
              println("With color: " + distractor.basecolor);
              
              distractorObjects.add(distractor);
            }
          }
        }

        break;
      }
    }
  }

  void resetTimers() {
    // reset timers
    testStartTime = millis();
    testTime = 0;
  }

  void update() {
    if (testNum >= testMax) {
      appState = APP_STATE_RESULTS;
      testNum = 0;
      initValues();
      return;
    }

    if (testIsRunning) {
      updateTest();
    } 
    else {
      updateInfo();
    }

    updateFooter();
  }

  void updateFooter() {
  }

  //--------------------------------------------//
  // result handling //
  //--------------------------------------------//

  void saveResults() {
    // update Result object
    Result res = (Result)results.get(testNum);
    res.reactionTime = (float)testTime / 1000.0f;

    if (testNum == 4) {
      testIsRunning = false;
      avgReactionTime = 0.0f;
      for (int i = 0; i < (testNum + 1); i++) {
        Result pastRes = (Result)results.get(i);
        avgReactionTime += pastRes.reactionTime / (testNum+1);
      }

      distrColor = randColor();
      objColor = randColor(distrColor);
    } 
    else if ((testNum+1) % 5 == 0) {
      testIsRunning = false;
      distrColor = randColor();
      objColor = randColor(distrColor);

      if (appState >= APP_STATE_TEST_6) {
        int objSize = 50;
        int objShape = (int)random(3);
        int objRandW = 0;
        int objRandH = 0;
        int objAngle = (int)random(360);

        objRandW = (int)random(-objSize / 2, objSize / 2);
        objRandH = (int)random(-objSize / 2, objSize / 2);

        switch (objShape) {
        default:
        case 0:
          objectToClick = new RectButton(0, 0, objSize + objRandW, objSize + objRandH, objColor, objColor, false);
          break;
        case 1:
          objectToClick = new CircleButton(0, 0, objSize + objRandW, objSize + objRandH, objColor, objColor, false);
          break;
        case 2:
          objectToClick = new TriangleButton(0, 0, objSize + objRandW, objSize + objRandH, objAngle, objColor, objColor, false);
          break;
        }
      }
    }

    // reset values
    initValues();    
    resetTimers();
    testNum++;

    println("Saved result:" + res);
  }

  //--------------------------------------------//
  // info functions //
  //--------------------------------------------//

  void displayInfo() {    
    ArrayList infoText = new ArrayList();
    //objectToClick = null;

    objectToClick.x = 400;
    objectToClick.y = 450;

    boolean dontDisplayObject = false;

    if (appState == APP_STATE_TEST_1) {
      infoText.add("Ihre durchschnittl. Reaktionsgeschwindigkeit ist " + nf(avgReactionTime, 1, 2) + "s");
    }

    if (appState == APP_STATE_TEST_3 || appState == APP_STATE_TEST_6) {
      infoText.add("Klicken Sie schnellstmöglich auf den größten Kreis!");
      dontDisplayObject = true;
    }

    if (!dontDisplayObject) {
      infoText.add("Klicken Sie jetzt im nächsten Test so schnell wie möglich auf folgendes Objekt:");
      objectToClick.display();
    }

    // help text
    fill(200);
    textFont(fontHeaderText, 20);
    textAlign(CENTER);

    for (int i = 0; i < infoText.size(); i++) {
      text((String)infoText.get(i), 400, 330 + i * 30);
    }

    // ok button
    infoOkButton.display();
  }

  void updateInfo() {
    infoOkButton.update();

    if (infoOkButton.pressed()) {
      resetTimers();
      testIsRunning = true;
      objectToClick.x = (int)random(testAreaSizeX - 100) + 100;
      objectToClick.y = (int)random(testAreaSizeY - 100) + 150;
    }
  }

  //--------------------------------------------//
  // test functions //
  //--------------------------------------------//

  void displayTest() {
    // display timer    
    fill(200);
    textFont(fontHeaderText, 20);
    textAlign(CENTER);
    textAlign(RIGHT);
    text(nf((float)testTime / 1000.0f, 1, 2) + " s", 700, 80);

    // show "experiment area"
    //testArea.display();

    // show content depending on the app state
    if (appState > APP_STATE_TEST_0) {
      for (int i = 0; i < distractorObjects.size(); i++) {        
        ((Button)distractorObjects.get(i)).display();
      }
    }

    // show the object that should be found
    objectToClick.display();
  }

  void updateTest() {
    // calculate timing
    testTime = millis() - testStartTime;

    // manage user interaction
    objectToClick.update();

    if (objectToClick.pressed()) {
      saveResults();
    }
  }

  //--------------------------------------------//
  // helper //
  //--------------------------------------------//

  color randColor() {
    return color((int)random(55, 255), (int)random(55, 255), (int)random(55, 255));
  }

  color randColor(color otherThan) {
    color c;
    float d;

    do {
      c = randColor();
      d = colorDist(c, otherThan);
    } 
    while(d < 30000);

    return c;
  }

  float colorDist(color c1, color c2) {
    float dR = red(c1) - red(c2);
    float dG = green(c1) - green(c2);
    float dB = blue(c1) - blue(c2);

    return dR * dR + dG * dG + dB * dB;
  }
}

