// 1. Test der "Reaktionsgeschw." (5x -> Durchschnitt)
// 2. Test der versch. Eigenschaften (einfach)
// 3. Test der versch. Eigenschaften (mit Distraktoren)
// 4. Test der versch. Eigenschaften (kombiniert)
// 5. Anzeige der Ergebnisse


final int APP_STATE_START = 0;
final int APP_STATE_TEST_0 = 1;
final int APP_STATE_TEST_1 = 2;
final int APP_STATE_TEST_2 = 3;
final int APP_STATE_TEST_3 = 4;
final int APP_STATE_TEST_4 = 5;
final int APP_STATE_TEST_5 = 6;
final int APP_STATE_TEST_6 = 7;
final int APP_STATE_TEST_7 = 8;
final int APP_STATE_TEST_8 = 9;
final int APP_STATE_TEST_9 = 10;
final int APP_STATE_RESULTS = 11;

final int SCREEN_W = 800;
final int SCREEN_H = 600;

final boolean DEBUG_VIS = false;

int appState;
PFont fontHeader;

AppTest appTest;
AppResults appResults;

ArrayList results = new ArrayList();  //List with testNum -> Result mapping
ArrayList testTitles = new ArrayList(); // List with Strings

void setup() {
  if (!DEBUG_VIS)
    appState = APP_STATE_TEST_0;
  else
    appState = APP_STATE_RESULTS;
    
  if (appState == APP_STATE_START) {
    appState = APP_STATE_TEST_0;
  }  
    
  smooth();
  size(SCREEN_W, SCREEN_H);
  stroke(255);
  background(0, 0, 0);
  
  fontHeader = loadFont("SansSerif-28.vlw");
  
  appTest = new AppTest();
  appResults = new AppResults();
  
  // fill the results with empty values
  for (int i = 0; i < appTest.testMax; i++) {
    Result res = new Result();
    res.testNum = i;
    
    if (DEBUG_VIS) {  // fill with random values for debugging
      if (i < 5) {
        res.reactionTime = random(0.5f, 0.9f);
      } else {
        res.reactionTime = random(0.1f, 2.5f);
      }
    }
    
    results.add(res);
  }
  
  // set test titles
  testTitles.add("Einfacher Reaktionst.");
  testTitles.add("Farbe");
  testTitles.add("Form");
  testTitles.add("Größe");
  testTitles.add("Distr.vielfalt I");
  testTitles.add("Distr.vielfalt II");
  testTitles.add("Distr.vielfalt III");
  testTitles.add("Zusammenges. Eig. I");
  testTitles.add("Zusammenges. Eig. II");
  testTitles.add("Zusammenges. Eig. III");
} 

void draw() {
  background(0, 0, 0);
  showHeader();
  updateMain();
  showMain();
  showFooter();
}

void showHeader() {
  fill(255);
  String title = "";
  
  switch (appState) {
    default:
      title = (String)testTitles.get(appState - 1);
    break;
    
    case APP_STATE_RESULTS:
      title = "Individuelle Resultate";
    break;
  }
  
  textFont(fontHeader, 28);
  textAlign(LEFT);
  text(title, 20, 50);
}

void updateMain() {
  if (appState != APP_STATE_RESULTS) {
    appTest.update();
  } else {
    appResults.update();
  }
}

void showMain() {
  if (appState != APP_STATE_RESULTS) {
    appTest.display();
  } else {
    appResults.display();
  }
}

void showFooter() {
  
}
