class Car implements ClickableObject {
  // content properties:
  String car;
  String manufacturer;
  float consumption;  // in km / liter
  int cylinders;
  float displacement;
  float horsepower;
  float weight; // in kg
  float accel;  // in sec from 0 to 60 mph
  int year;
  String origin;

  // graphical properties:
  int sphereSize = 20;
  color objColor = color(255, 255, 255, 255);
  color textColor = color(0, 0, 0, 255);
  PFont nodeFont;
  float textW = 0;
  float textH = 14;

  // links to other objects in the group:
  Car nextCar = null;
  Manufacturer manuObj = null;
  InfoWindow infoWindow = null;

  // force-directed layout stuff:
  Node carNode = null;
  Spring springToNextCar = null;
  Spring springToManu = null;

  // interaction stuff:
  int lastClick = 0;  // in millis
  int clickTimeout = 500;
  int wasSetToVisible = 0;

  Car(String fLine) {
    // parse data line
    String[] data = splitTokens(fLine, "\t");

    int i = 0;
    car = data[i++];
    manufacturer = data[i++];
    consumption = float(data[i++]) * 1.609 / 3.785;  // mpg to km-p-l
    cylinders = int(data[i++]);
    displacement = float(data[i++]) * 16.387;
    horsepower = float(data[i++]);
    weight = float(data[i++]) * 0.4536;
    accel = float(data[i++]);
    year = int(data[i++]);
    origin = data[i++];

    // fix buick anomaly
    if (manufacturer.equals("buick")) {
      if (origin.toLowerCase().equals("american")) {
        manufacturer += " (us)";
      } 
      else {
        manufacturer += " (eu)";
      }
    }
    
    // set maxima
    if (consumption > dataMax.consumption) {
      dataMax.consumption = consumption;
    }
    
    if (cylinders > dataMax.cylinders) {
      dataMax.cylinders = cylinders;
    }
    
    if (displacement > dataMax.displacement) {
      dataMax.displacement = displacement;
    }
    
    if (horsepower > dataMax.horsepower) {
      dataMax.horsepower = horsepower;
    }
    
    if (weight > dataMax.weight) {
      dataMax.weight = weight;
    }
    
    if (accel > dataMax.accel) {
      dataMax.accel = accel;
    }
    
    if (year > dataMax.year) {
      dataMax.year = year;
    }

    // create info window
    infoWindow = new InfoWindow(this);
  }

  void createNode(int x, int y) {
    carNode = new Node(x, y, 0);
    carNode.setStrength(-2);
    carNode.setDamping(0.1);
    carNode.setBoundary(NODE_BOUNDARY, NODE_BOUNDARY, 0, width - NODE_BOUNDARY, height - NODE_BOUNDARY, 0);
  }

  void createSpringToManu() {
    springToManu = new Spring(carNode, manuObj.manuNode);
    springToManu.setStiffness(0.7);
    springToManu.setDamping(0.9);
    springToManu.setLength(100);
  }

  void createSpringToNextCar(int springLength) {
    springToNextCar = new Spring(carNode, nextCar.carNode);
    springToNextCar.setStiffness(0.7);
    springToNextCar.setDamping(0.9);
    springToNextCar.setLength(springLength);
  }
  
  boolean clickAtPos(int px, int py) {
    // update interactions
    if (wasSetToVisible > 0 && overRect(px, py, (int)carNode.x - (int)textW/2, (int)carNode.y - (int)textH/2, (int)textW, (int)textH)) {
//      int now = millis();
//      if ((now - wasSetToVisible > clickTimeout) && (now - lastClick > clickTimeout)) {
        println("Click on " + car);

        if (!infoWindow.visible) {
          infoWindow.open((int)carNode.x, (int)carNode.y);
        }

//        lastClick = now;
//      }

      return true;
    }
    
    return false;
  }

  void update() {
    // update attractions
    attractToNodes();

    // update springs
    if (springToManu != null) {
      springToManu.update();
    }

    if (springToNextCar != null) {
      springToNextCar.update();
    }

    // update nodes
    if (carNode != null) {
      carNode.update();
    }
    
    // update window
    if (infoWindow.visible) {
      infoWindow.update();
    }
  }

  void draw() {
    drawSelf();
    drawDebug();

    //infoWindow.draw();
  }

  private void drawSelf() {
    noStroke();
    fill(objColor);

    pushMatrix();

    translate(carNode.x, carNode.y, 1);

    //ellipse(0, 0, sphereSize, sphereSize);

    String nodeTitle = car.toUpperCase();
    textW = textWidth(nodeTitle) + 2;
    
    fill(color(255, 255, 255, 255));
    rectMode(CENTER);
    rect(0, 0, textW, textH);

    fill(color(0, 0, 0, 255));
    textFont(nodeFont, 14);
    textAlign(CENTER);
    text(nodeTitle, 0, 5);
    

    popMatrix();
  }

  private void drawDebug() {
    // draw springs
    stroke(255, 255, 0, 255);
    strokeWeight(2);

    if (carNode != null && manuObj != null && springToManu != null) {
      line(carNode.x, carNode.y, 0, manuObj.manuNode.x, manuObj.manuNode.y, 0);
    }

    if (carNode != null && nextCar != null && springToNextCar != null) {
      line(carNode.x, carNode.y, 0, nextCar.carNode.x, nextCar.carNode.y, 0);
    }
  }

  private void attractToNodes() {
    if (carNode != null && manuObj != null) {
      carNode.attract(manuObj.manuNode);
      manuObj.manuNode.attract(carNode);
    }

    if (carNode != null && nextCar != null) {
      carNode.attract(nextCar.carNode);
      nextCar.carNode.attract(carNode);
    }
  }

  String toString() {
    String s = "Car: ";

    s += car + ",";
    s += manufacturer + ",";
    s += consumption + ",";
    s += cylinders + ",";
    s += displacement + ",";
    s += horsepower + ",";
    s += weight + ",";
    s += accel + ",";
    s += year + ",";
    s += origin;

    return s;
  }
}

