interface DragableObject {
  boolean startDragAtPos(int px, int py);
  boolean dragAtPos(int px, int py);
}

interface ClickableObject {
  boolean clickAtPos(int px, int py);
}

class IAManager {
  ArrayList originList = null;
  ArrayList windowList = new ArrayList();
  
  DragableObject curDragableObj = null;
  
  IAManager(ArrayList pOriginList) {
    originList = pOriginList;
  }
  
  void registerWindow(InfoWindow wnd) {
    if (!windowList.contains(wnd)) {
      windowList.add(wnd);
    }
  }
  
  void unregisterWindow(InfoWindow wnd) {
    if (windowList.contains(wnd)) {
      windowList.remove(windowList.indexOf(wnd));
    }
  }
  
  void drawWindows() {
    for (int i = 0; i < windowList.size(); i++) {
      InfoWindow w = (InfoWindow)windowList.get(i);
      
      w.update();
      w.draw();
    }
  }
  
  void click(int x, int y) {
    for (int i = 0; i < windowList.size(); i++) {
      InfoWindow w = (InfoWindow)windowList.get(i);
      
      if (w.clickAtPos(x, y)) {
        return;
      }
    }
    
    for (int i = 0; i < originList.size(); i++) {
      Origin o = (Origin)originList.get(i);
            
      for (int j = 0; j < o.manus.size(); j++) {
        Manufacturer m = (Manufacturer)o.manus.get(j);
        
        if (m.clickAtPos(x, y)) {
          return;
        }
        
        for (int k = 0; k < m.cars.size(); k++) {
          Car c = (Car)m.cars.get(k);
          
          if (c.clickAtPos(x, y)) {
            return;
          }
        }
      }
    }
  }
  
  void press(int x, int y) {
    for (int i = 0; i < windowList.size(); i++) {
      InfoWindow w = (InfoWindow)windowList.get(i);
      
      if (w.startDragAtPos(x, y)) {
        curDragableObj = w;
        
        println("Start to drag with window#" + i);
        
        return;
      }
    }
  }
  
  void release(int x, int y) {
    curDragableObj = null;
  }
  
  void drag(int x, int y) {
    if (curDragableObj != null) {
      curDragableObj.dragAtPos(x, y);
    }
  }
}
