class InfoWindow implements DragableObject, ClickableObject {
  // data:
  Car car;

  // status:
  boolean visible = false;

  // position and size:
  int x;
  int y;
  int w = 400;
  int h = 170;
  int headerH = 30;
  
  int closeX = headerH/2 + 1;
  int closeY = headerH/2;
  int closeCircleDia = headerH - 5;
  
  int startDragX;
  int startDragY;

  // appearance:
  color borderColor = color(255, 255, 255, 192);
  color bgColor = color(0, 0, 0, 196);
  color closeButtonColor = color(40, 40, 40, 255);
  color headerColor = color(255, 255, 255, 64);
  color headerTextColor = color(255, 255, 255, 255);
  color contentTextColor = color(255, 255, 255, 255);
  PFont headerFont;
  PFont contentFont;

  InfoWindow(Car pCar) {
    car = pCar;
    
    headerFont = manuNodeFont;
    contentFont = carNodeFont;
  }
  
  boolean startDragAtPos(int px, int py) {
    if (overRect(px, py, x, y, w, headerH)) {
      if (overCircle(px, py, x + closeX - closeCircleDia / 2, y + closeY, closeCircleDia + 5)) {
        this.close();
        
        return true;
      }
      
      startDragX = px - x;
      startDragY = py - y;
      
      return true;
    }
    
    return false;
  }
  
  boolean dragAtPos(int px, int py) {
    x = px  - startDragX;
    y = py - startDragY;
    
    return false;
  }
  
  boolean clickAtPos(int px, int py) {
    if (overRect(px, py, x, y, w, h)) {
      if (overCircle(px, py, x + closeX - closeCircleDia / 2, y + closeY, closeCircleDia + 5)) {
        this.close();
      }
      
      return true;
    }

    return false;
  }
  
  void open(int px, int py) {
    if (visible) return;
    
    visible = true;
    setAtCenterPos(px, py);
    iaManager.registerWindow(this);
  }
  
  void close() {
    if (!visible) return;
    
    visible = false;
    iaManager.unregisterWindow(this);
  }

  void setAtCenterPos(int cX, int cY) {
    x = cX - w / 2;
    y = cY - h / 2;
    
    if (y < 0) {
      y = 0;
    }
  }

  void draw() {
    if (visible) {
      pushMatrix();

      translate(x, y, 20);

      drawWindow();
      drawHeader();
      drawContent();

      popMatrix();
    }
  }

  void update() {
    
  }

  private void drawWindow() {
    strokeWeight(1);
    stroke(borderColor);
    fill(bgColor);
    rectMode(CORNER);

    rect(0, 0, w, h);
  }

  private void drawHeader() {
    noStroke();
    fill(headerColor);
    rectMode(CORNER);
    rect(0, 0, w, headerH);
    
    fill(headerTextColor);
    textFont(headerFont, 16);
    textAlign(CENTER);
    text((car.manufacturer + " " + car.car + " ('" + (int)car.year + ")").toUpperCase(), w / 2, headerH / 2 + 5);
    
    ellipseMode(CENTER);
    fill(closeButtonColor);
    noStroke();
    ellipse(closeX, closeY, closeCircleDia, closeCircleDia);
    stroke(color(255, 255, 255, 255));
    strokeWeight(2);
    line(closeX - 5, closeY - 5, closeX + 5, closeY + 5);
    line(closeX - 5, closeY + 5, closeX + 5, closeY - 5);    
  }

  private void drawContent() {
    int barX = 10;
    int barY = headerH + 10;
    int barMaxW = 280;
    int barH = 15;
    int barBorder = 5;
    
    drawBar(barX, barY, barMaxW, barH, "Consuption", car.consumption, "km / liter", dataMax.consumption, 2);
    barY += (barH + barBorder);
    drawBar(barX, barY, barMaxW, barH, "Weight", car.weight, "kg", dataMax.weight, 2);
    barY += (barH + barBorder);
    drawBar(barX, barY, barMaxW, barH, "Displacement", car.displacement, "ccm", dataMax.displacement, 2);
    barY += (barH + barBorder);
    drawBar(barX, barY, barMaxW, barH, "Horsepower", car.horsepower, " HP", dataMax.horsepower, 0);
    barY += (barH + barBorder);
    drawBar(barX, barY, barMaxW, barH, "Cylinders", car.cylinders, "", dataMax.cylinders, 0);
    barY += (barH + barBorder);
    drawBar(barX, barY, barMaxW, barH, "Acceleration", car.accel, " sec", dataMax.accel, 2);
  }
  
  private void drawBar(int barX, int barY, int barMaxW, int barH, String title, float v, String unit, float vMax, int digitsAfterComma) {
    float perc = v / vMax;
    int barW = (int)(perc * barMaxW);
    color barColor = color(50 + 200.0f * perc, 250 - 200.0f * perc, 0);
    
    noStroke();
    
    fill(contentTextColor);
    textFont(contentFont, 14);
    textAlign(LEFT);
    text(title, barX, barY + 12);

    fill(barColor);
    rect(barX + 100, barY, barW, barH);
    
    fill(contentTextColor);
    textFont(contentFont, 14);
    textAlign(RIGHT);
    text(nf(v, 1, digitsAfterComma) + " " + unit, barX + 100 + barMaxW, barY + 12);
  }
}

