class Manufacturer implements ClickableObject {
  // content properties:
  String name;

  // graphical properties:
  int sphereSize = 30;
  color objColor = color(255, 255, 255, 192);
  color textColor = color(0, 0, 0, 255);
  PFont nodeFont;

  // links to all objects in this group:
  Manufacturer nextManu;
  ArrayList cars;  // List with Car objects

    // force-directed layout stuff:
  Node centerNode = null;
  Node manuNode = null;
  Spring springToCenter = null;
  Spring springToNextManu = null;
  boolean showCars = false;
  int maxCarsPerGroup = 12;
  int curGroupNum = 0;
  int carStartNum = 0;
  int carEndNum = 0;
  int carNumGroups = 0;

  // interaction stuff:
  int lastClick = 0;  // in millis
  int clickTimout = 500;

  Manufacturer(String pName, ArrayList pCars, Node pCenterNode) {
    name = pName;
    centerNode = pCenterNode;

    if (pCars == null)
      cars = new ArrayList();
    else {
      cars = pCars;

      curGroupNum = -1;
      carNumGroups = (int)ceil(cars.size() / maxCarsPerGroup) + 1;

      // set links in cars
      for (int i = 0; i < cars.size(); i++) {
        Car c = (Car)cars.get(i);

        // set link to manufacturer
        c.manuObj = this;

        // set links to next car
        //        if (i + 1 < cars.size()) {
        //          c.nextCar = (Car)cars.get(i + 1);
        //        } 
        //        else {
        //          c.nextCar = (Car)cars.get(0);
        //        }
      }
    }
  }

  void createNode(int x, int y) {
    manuNode = new Node(x, y, 0);
    manuNode.setStrength(-2);
    manuNode.setDamping(0.1);
    manuNode.setBoundary(NODE_BOUNDARY, NODE_BOUNDARY, 0, width - NODE_BOUNDARY, height - NODE_BOUNDARY, 0);
    manuNode.setDiameter(sphereSize);

    // create car nodes
    //    Car c = null;

    for (int i = 0; i < cars.size(); i++) {
      Car c = (Car)cars.get(i);

      c.createNode(0, 0);    // initial positions are set in initCarNodePositions()
      c.createSpringToManu();

      //      if (i > 0) {
      //        Car prev = (Car)cars.get(i - 1);
      //        //prev.createSpringToNextCar(100);
      //      }
    }

    //c.createSpringToNextCar(100);
  }

  void createSpringToCenter(int springLength) {
    springToCenter = new Spring(manuNode, centerNode);
    springToCenter.setStiffness(0.7);
    springToCenter.setDamping(0.9);
    springToCenter.setLength(springLength);
  }

  void createSpringToNextManu(int springLength) {
    springToNextManu = new Spring(manuNode, nextManu.manuNode);
    springToNextManu.setStiffness(0.7);
    springToNextManu.setDamping(0.9);
    springToNextManu.setLength(springLength);
  }

  boolean clickAtPos(int px, int py) {
    // update interactions
    if (overCircle(px, py, (int)manuNode.x, (int)manuNode.y, sphereSize)) {
      //      int now = millis();
      //      if (now - lastClick > clickTimout) {
      println("Click on " + name);
      
      // enable showing cars at the beginning
      if (curGroupNum < 0 && !showCars) {
        showCars = true;
      }
      
      // increase car group number
      curGroupNum++;
      
      // disable showing cars if the last car group was reached
      if (curGroupNum >= carNumGroups) {
        showCars = false;
        curGroupNum = -1;
      }
      
      // calculate start and end car numbers
      carStartNum = curGroupNum * maxCarsPerGroup;
      carEndNum = carStartNum + maxCarsPerGroup;
      if (carEndNum > cars.size()) {
        carEndNum = cars.size();
      }

      // init or hide car nodes
      if (showCars) {
        initCarNodePositions();
      } 
      else {
        hideCarNodes();
      }

      //        lastClick = now;
      //      }

      return true;
    }

    return false;
  }

  void update() {    
    // update cars
    if (showCars) {
      for (int i = carStartNum; i < carEndNum; i++) {
        Car c = (Car)cars.get(i);

        c.update();
      }
    }

    // update attractions
    attractToNodes();

    // update springs
    if (springToCenter != null) {
      springToCenter.update();
    }

    if (springToNextManu != null) {
      springToNextManu.update();
    }

    // update nodes
    if (manuNode != null) {
      manuNode.update();
    }
  }

  void draw() {
    // draw cars
    if (showCars) {
      for (int i = carStartNum; i < carEndNum; i++) {
        Car c = (Car)cars.get(i);

        c.draw();
      }
    }

    drawSelf();
    //drawDebug();
  }

  private void drawSelf() {
    noStroke();
    fill(objColor);

    pushMatrix();

    translate(manuNode.x, manuNode.y, 0);

    // draw circle
    fill(objColor);
    ellipse(0, 0, sphereSize, sphereSize);
    
    // draw group circle & number
    fill(objColor);

    ellipse(sphereSize / 2.25f, sphereSize / 2.25f, sphereSize / 1.15f, sphereSize / 1.15f);
    
    String numText;
    if (showCars) {
      numText = (carStartNum + 1) + "-" + carEndNum;
    } 
    else {
      numText = "" + cars.size();
    }

    fill(textColor);
    textFont(carNodeFont, 14);
    textAlign(CENTER);

    text(numText, sphereSize / 2.25f, sphereSize / 2.25f + 5);
    
    // draw manufacturer name
    fill(textColor);
    textFont(nodeFont, 16);
    textAlign(CENTER);
    text(name.toUpperCase(), 0, 5);

    popMatrix();
  }

  private void drawDebug() {
    // draw springs
    stroke(0, 255, 255, 255);
    strokeWeight(4);

    if (manuNode != null && centerNode != null && springToCenter != null) {
      line(manuNode.x, manuNode.y, 0, centerNode.x, centerNode.y, 0);
    }

    if (manuNode != null && nextManu != null && springToNextManu != null) {
      line(manuNode.x, manuNode.y, 0, nextManu.manuNode.x, nextManu.manuNode.y, 0);
    }
  }

  private void attractToNodes() {    
    if (manuNode != null && centerNode != null) {
      manuNode.attract(centerNode);
      centerNode.attract(manuNode);
    }

    if (manuNode != null && nextManu != null) {
      manuNode.attract(nextManu.manuNode);
      nextManu.manuNode.attract(manuNode);
    }
  }

  protected void initCarNodePositions() {
    int numCars = carEndNum - carStartNum;
    
    float carRadiantIncr = 2 * PI / numCars;
    float carRadiant = 0.0f;

    for (int i = carStartNum; i < carEndNum; i++) {
      Car c = (Car)cars.get(i);

      c.wasSetToVisible = millis();

      c.carNode.x = manuNode.x + (cos(carRadiant) * 10.0f);
      c.carNode.y = manuNode.y + (sin(carRadiant) * 10.0f);
      carRadiant += carRadiantIncr;
    }
  }

  protected void hideCarNodes() {
    for (int i = 0; i < cars.size(); i++) {
      Car c = (Car)cars.get(i);

      c.wasSetToVisible = 0;
    }
  }
}

