class Origin {
  // content properties:
  String name;
  
  // graphical properties:
  int ringDiameter;
  color ringColor;
  PFont ringFont;
  color textColor = color(0, 0, 0, 255);
  
  // links to all objects in this group:
  ArrayList manus; // ArrayList with Manufacturer objects
  
  
  Origin(String pName, int pRingDiameter, color pRingColor) {
    println("> New origin " + pName + "(" + pRingDiameter + ")");
    
    name = pName;
    ringDiameter = pRingDiameter;
    ringColor = pRingColor;
    
    manus = new ArrayList();
  }
  
  void update() {
    
  }
  
  void draw() {
    fill(ringColor);
    noStroke();
    ellipse(width/2, height/2, ringDiameter, ringDiameter);
    
    if (name != null && name.length() > 0) {
      fill(textColor);
      if (ringDiameter <= 100) {
        textFont(centerFont, 48);
        
        stroke(textColor);
        strokeWeight(4);
        
        textAlign(CENTER);
        text(name.toUpperCase(), width/2, height/2 + 15);
      
//        for (int i = 0; i < 3; i++) {
//          textAlign(LEFT);
//          text(name.toUpperCase(), width/2 + ringDiameter / 2 - 100 + i * 10, height/2 - 5 + i * 23);
//        }
      } else {
        textFont(ringFont, 18);
        textAlign(CENTER);
        text(name.toUpperCase(), width/2 + ringDiameter / 2 - 55, height/2 - 30);
      }
    }
    
    for (int i = 0; i < manus.size(); i++) {
      Manufacturer m = (Manufacturer)manus.get(i);
      //centerAttractor.attract(m.manuNode);
      m.update();
      m.draw();
    }
  }
}
