
import generativedesign.*;
import processing.opengl.*;

// problem mit zu vielen autos bei ford & co. (mehrmals auf manu klicken?)

IAManager iaManager = null;  // interaction manager

Node centerNode;
//Attractor centerAttractor;
ArrayList originList = new ArrayList();  // ArrayList of Origin objects
DataMaxima dataMax = new DataMaxima();

color ringColor = color(255, 255, 255, 80);

// fonts
PFont carNodeFont;
PFont manuNodeFont;
PFont ringFont;
PFont centerFont;

static final int NODE_BOUNDARY = 10;

void setup() {  
  // setup screen
  size(1024, 768, OPENGL);
  lights();
  smooth();
  fill(0);
  textMode(MODEL);

  // setup graphical stuff
  carNodeFont = loadFont("MyriadPro-BoldCond-14.vlw");    
  manuNodeFont = loadFont("MyriadPro-BoldCond-16.vlw");
  ringFont = loadFont("MyriadPro-BoldCond-18.vlw");
  centerFont = loadFont("MyriadPro-BoldCond-42.vlw");
  
  // read car data
  String[] carStrings = loadStrings("cars.txt");
  HashMap originsAndManus = new HashMap();  // String origins -> ArrayList String manufactures
  HashMap manusAndCars = new HashMap();  // String manufractures -> ArrayList Cars cars

  for (int i = 1; i < carStrings.length; i++) {
    Car c = new Car(carStrings[i]);
    c.nodeFont = carNodeFont;

    //     println(c);

    if (originsAndManus.containsKey(c.origin)) {  // add manufacture to existing origin
      ArrayList manusInOrigin = (ArrayList)originsAndManus.get(c.origin);

      if (!manusInOrigin.contains(c.manufacturer)) {
        manusInOrigin.add(c.manufacturer);
      }
    } 
    else {
      ArrayList manusInOrigin = new ArrayList();
      manusInOrigin.add(c.manufacturer);
      originsAndManus.put(c.origin, manusInOrigin);  // add new origin with first manufacturer in list
    }

    // aggregate data in hashmap
    if (manusAndCars.containsKey(c.manufacturer)) {  // add car to existing manufacturer
      ((ArrayList)manusAndCars.get(c.manufacturer)).add(c);
    } 
    else {
      ArrayList l = new ArrayList();
      l.add(c);
      manusAndCars.put(c.manufacturer, l);  // add new manufacturer with first car in list
    }
  }

  println("Loaded " + (carStrings.length - 1) + " cars");
  println("Loaded " + originsAndManus.size() + " origins");
  println("Loaded " + manusAndCars.size() + " manufacturers");

  // sort origin list by number of manufacturers in it
  Map sortedOrigins = sortByArrayListSize(originsAndManus); 

  //  for (Iterator it = sortedOrigins.entrySet().iterator(); it.hasNext();) {
  //    Map.Entry pair = (Map.Entry)it.next();
  //    
  //    String originName = (String)pair.getKey();
  //    ArrayList manusInOrigin = (ArrayList)pair.getValue();
  //    
  //    println("> Loaded origin: " + originName + " with " + manusInOrigin.size() + " manufacturers");
  //  }

  // create center objects
  centerNode = new Node(width/2, height/2, 0);
  centerNode.setStrength(-2);
  centerNode.setDamping(0.1);
  centerNode.setBoundary(0, 0, 0, width, height, 0);

  //  centerAttractor = new Attractor(width/2, height/2, 0);
  //  centerAttractor.setMode(Attractor.SMOOTH);
  //  centerAttractor.setRadius(500);
  //  centerAttractor.setStrength(5);

  // process data in hashmaps and get Origin objects with Manufacturer objects with Cars in them
  Iterator it = sortedOrigins.entrySet().iterator();
  int originNum = 0;
  int ringWidth = 300 / sortedOrigins.size();

  Origin innerRing = new Origin("Cars", 100, ringColor);
  originList.add(innerRing);

  while (it.hasNext()) {
    Map.Entry pair = (Map.Entry)it.next();

    String originName = (String)pair.getKey();
    ArrayList manusInOrigin = (ArrayList)pair.getValue();
    println("> Loaded origin #" + originNum + ": " + originName + " with " + manusInOrigin.size() + " manufacturers");

    Manufacturer prevManu = null;
    Manufacturer firstManu = null;
    boolean isFirstManu = true;

    Origin curOrigin = new Origin(originName, 2 * (100 + originNum * ringWidth) + 100, ringColor);
    curOrigin.ringFont = ringFont;

    float manuRadiantIncr = 2 * PI / manusInOrigin.size();
    float manuRadiant = 0.0f;

    for (int i = 0; i < manusInOrigin.size(); i++) {
      String manuName = (String)manusInOrigin.get(i);
      //println(">> Loaded manu: " + manuName);

      ArrayList manuCars = (ArrayList)manusAndCars.get(manuName);

      Manufacturer manu = new Manufacturer(manuName, manuCars, centerNode);
      manu.nodeFont = manuNodeFont;

      //      int manuNodeX = (int)random(200, width - 200);
      //      int manuNodeY = (int)random(100, height - 100);
      int manuNodeX = width / 2 + (int)(cos(manuRadiant) * 10.0f);
      int manuNodeY = height / 2 + (int)(sin(manuRadiant) * 10.0f);
      manuRadiant += manuRadiantIncr;

      manu.createNode(manuNodeX, manuNodeY);
      manu.createSpringToCenter(100 + originNum * ringWidth);
      //      manu.createSpringToCenter(300);

      if (isFirstManu) {
        firstManu = manu;

        isFirstManu = false;
      } 
      else {  
        prevManu.nextManu = manu;
        //      prevManu.createSpringToNextManu(200);
      }

      curOrigin.manus.add(manu);
      prevManu = manu;
    }

    prevManu.nextManu = firstManu;
    //  prevManu.createSpringToNextManu(200);

    //    firstManu.showCars = true;

    originList.add(curOrigin);

    originNum++;

    // create Interaction manager
    iaManager = new IAManager(originList);
  }
}

void mousePressed() {
  iaManager.press(mouseX, mouseY);
}

void mouseClicked() {
  iaManager.click(mouseX, mouseY);
}

void mouseDragged() {
  iaManager.drag(mouseX, mouseY);
}

void mouseReleased() {
  iaManager.release(mouseX, mouseY);
}


void draw() {
  background(0);
  drawContent();
  iaManager.drawWindows();
}

private void drawContent() {
  for (int i = 0; i < originList.size(); i++) {
    Origin o = (Origin)originList.get(i);

    o.update();
    o.draw();
  }
}

boolean overCircle(int px, int py, int cx, int cy, int diameter) 
{
  float disX = cx - px;
  float disY = cy - py;
  if(sqrt(sq(disX) + sq(disY)) < diameter/2 ) {
    return true;
  } 
  
  return false;
}

boolean overRect(int px, int py, int rx, int ry, int w, int h) 
{
  if (px >= rx && px <= rx + w && py >= ry && py <= ry + h) {
    return true;
  } 
  
  return false;
}

private Map sortByArrayListSize(Map map) {
  List list = new LinkedList(map.entrySet());
  Collections.sort(list, new Comparator() {
    public int compare(Object o1, Object o2) {
      ArrayList l1 = (ArrayList)(((Map.Entry) (o1)).getValue());
      ArrayList l2 = (ArrayList)(((Map.Entry) (o2)).getValue());
      Integer count1 = new Integer(l1.size());
      Integer count2 = new Integer(l2.size());

      return ((Comparable) count1).compareTo(count2);
    }
  }
  );

  Map result = new LinkedHashMap();
  for (Iterator it = list.iterator(); it.hasNext();) {
    Map.Entry entry = (Map.Entry)it.next();
    result.put(entry.getKey(), entry.getValue());
  }
  return result;
} 

